#include "pch.h"

#include <sys\types.h>
#include <errno.h>

#include "Common.hpp"
#include "Misc.hpp"

#include "Adrenalin.h"

LPCTSTR	arrszMonthNames[] = { _T("Jan"), _T("Feb"), _T("Mar"), _T("Apr"),
			      _T("May"), _T("Jun"), _T("Jul"), _T("Aug"),
			      _T("Sep"), _T("Oct"), _T("Nov"), _T("Dec") };


void GetCurrentDateTime(LPTSTR szDateTime) {
	SYSTEMTIME  LocTime;

	GetLocalTime( &LocTime );

	wsprintf( szDateTime, _T("%02hu %s %02hu  %02hu:%02hu:%02hu"),
			LocTime.wDay,
			arrszMonthNames[LocTime.wMonth-1],
			LocTime.wYear %= 100, LocTime.wHour,
			LocTime.wMinute, LocTime.wSecond );
}


void GetCurrentDateTimeY2K(LPTSTR szDateTime) {
	SYSTEMTIME  LocTime;

	GetLocalTime( &LocTime );

	wsprintf( szDateTime, _T("%02hu %s %04hu %02hu:%02hu:%02hu"),
		LocTime.wDay,
		arrszMonthNames[LocTime.wMonth-1],
		LocTime.wYear,
		LocTime.wHour,
		LocTime.wMinute,
		LocTime.wSecond );
}


/**
 * Gets current local time and stores it in szTime.
 * szTime must point to at least 20 bytes long buffer
 */

void GetTimeForLog(LPTSTR szTime) {
	SYSTEMTIME	localTime;

	::GetLocalTime( &localTime );

	_stprintf( szTime, TEXT("%04hu/%02hu/%02hu %02hu:%02hu:%02hu"),
		   localTime.wYear, localTime.wMonth, localTime.wDay,
		   localTime.wHour, localTime.wMinute, localTime.wSecond );
}


long GetFileNumber(LPCTSTR szFileName) {
	int  i;       // reading not more than 8 numbers
	long Number;

	i = 0;
	Number = 0;
	while (i < 8 && _istdigit(*szFileName)) {
		Number *= 10;
		Number += (*szFileName - _T('0'));
		szFileName++;
		i++;
	}
	if (*szFileName != _T('.'))
		Number = 0;

	return (Number);
}


long GetFileNumberHex(LPCTSTR szFileName) {
    int  i;       // reading not more than 8 numbers
    long Number;

    i = 0;
    Number = 0;
    while (i < 8 && IsCharAlphaNumeric(*szFileName)) {
        Number <<= 4; // *16
        if (_istdigit(*szFileName)) {
            Number += *szFileName - _T('0');
        }
        else {
            Number += LOWORD(CharUpper( (LPTSTR)MAKELONG((WORD)*szFileName, 0) )) - _T('A') + 10;
        }
        szFileName++;
        i++;
    }
    if (*szFileName != _T('.'))
        Number = 0;

    return (Number);
}

int GetNumberOfEnclosedNames(LPCTSTR szFileName) {
    int Number;
    int i;

    if (*szFileName == _T('\0'))
        return (0);
    
    Number = 0;
    i = 0;
    while (szFileName[i] != _T('\0')) {
        if (szFileName[i] == _T('\\'))
            Number++;
        i++;
    }
    if (szFileName[i-1] != _T('\\'))
        Number++;

    return (Number);
}

int MakeDirStructure(LPCTSTR szDirName, int SkipNumber) {
    int i;
    static TCHAR szDir[MAX_PATH];
    int Success;

    // skips names
    i = 0;
    while (SkipNumber > 0) {
        while (szDirName[i] != _T('\0') && szDirName[i] != _T('\\')) {
            szDir[i] = szDirName[i];
            i++;
        }
        szDir[i] = szDirName[i];
        i++;
        SkipNumber--;
    }
    // make structure
    Success = 1;
    while (szDirName[i] != _T('\0')) {
        while (szDirName[i] != _T('\0') && szDirName[i] != _T('\\')) {
            szDir[i] = szDirName[i];
            i++;
        }
        szDir[i] = szDirName[i];
        if (szDirName[i] != _T('\0')) {
            i++;
            szDir[i] = _T('\0');
        }
        if (_tmkdir( szDir ) != 0) {
            Success &= (errno == EACCES);
        }
    }
    return (Success);
}

long GetFreeDirNumber(LPCTSTR szFindFileMask) {
    WIN32_FIND_DATA FindFileData;
    HANDLE          hFindFile;
    BOOL            fFileFound;
    long            lMaxNumber, lNumber;
    
    lMaxNumber = 0;
    hFindFile = FindFirstFile( szFindFileMask, &FindFileData );
    fFileFound = (hFindFile != INVALID_HANDLE_VALUE);
    while (fFileFound) {
        lNumber = GetFileNumber( FindFileData.cFileName );
        if (lNumber > lMaxNumber)
            lMaxNumber = lNumber;
        fFileFound = FindNextFile( hFindFile, &FindFileData );
    }
    if (hFindFile != INVALID_HANDLE_VALUE)
        FindClose( hFindFile );
    return (lMaxNumber+1);
}

long GetFreeDirNumberHex(LPCTSTR szFindFileMask) {
    WIN32_FIND_DATA FindFileData;
    HANDLE          hFindFile;
    BOOL            fFileFound;
    long            lMaxNumber, lNumber;
    
    lMaxNumber = 0;
    hFindFile = FindFirstFile( szFindFileMask, &FindFileData );
    fFileFound = (hFindFile != INVALID_HANDLE_VALUE);
    while (fFileFound) {
        lNumber = GetFileNumberHex( FindFileData.cFileName );
        if (lNumber > lMaxNumber)
            lMaxNumber = lNumber;
        fFileFound = FindNextFile( hFindFile, &FindFileData );
    }
    if (hFindFile != INVALID_HANDLE_VALUE)
        FindClose( hFindFile );
    return (lMaxNumber+1);
}

long int GetFileSize(FILE *f) {
    long int save_pos, size_of_file;

    save_pos = ftell( f );
    fseek( f, 0L, SEEK_END );
    size_of_file = ftell( f );
    fseek( f, save_pos, SEEK_SET );
    return( size_of_file );
    
}

int IsAlpha(char *s) {
    if (*s == '\0')
        return (0);
    while (*s != '\0') {
        if (!isalpha(*s))
            break;
        s++;
    }
    return (*s == '\0');
}

void RemoveBoundaryQuotes(char *s) {
    int len;
    int i;

    len = strlen(s);
    if (len < 2)
        return;
    len--;
    s[len] = '\0';
    for (i = 0; i < len; i++)
        s[i] = s[i+1];
}

int GetOnBit(unsigned long bitarray) {
    int i;
    unsigned long bit;

    i   = 0;
    bit = 1;
    while ((bitarray & bit) == 0 && i < 32) {
        bit <<= 1;
        i++;
    }
    return (i < 32 ? i : -1);
}

bool CheckMask(LPCTSTR szValue, LPCTSTR szMask) {
    while (*szMask != _T('\0')) {
        switch (*szMask) {
        case _T('?'):
            szMask++;
            if (*szValue != _T('\0'))
                szValue++;
            break;
        case _T('*'):
            szMask++;
            while (*szValue != _T('\0')) {
                if (CheckMask(szValue, szMask))
                    break;
                else
                    szValue++;
            }
            if (*szValue != _T('\0') || CheckMask(szValue, szMask))
                return (true);
            else
                return (false);
        default:
			// we can avoid this check, but code is more clear
			if ((*szValue) == TEXT('\0'))
				return (false);
            if (ToUpper(*szMask) != ToUpper(*szValue))
                return (false);
            szMask++;
            szValue++;
        }
    }
    return (*szValue == _T('\0'));
}

bool IsMask(LPCTSTR szValue) {
    while (*szValue != _T('\0')) {
        if (*szValue == _T('*') || *szValue == _T('?'))
            return (true);
        szValue++;
    }
    return (false);
}


FileOpResult MyMoveFile(LPCTSTR szSourceFileName, LPCTSTR szDestFileName) {
	// check if on the same drive
	if (szSourceFileName[0] == szDestFileName[0]) {
		_tunlink( szDestFileName );
		if (_trename( szSourceFileName, szDestFileName ) == 0) {
			return FO_SUCCEEDED;
		}
		switch (errno) {
			case EACCES:
				return FO_DEST_UNAVAILABLE;
			case ENOENT:
				return FO_SOURCE_UNAVAILABLE;
			case EINVAL:
				return FO_DEST_INVALID;
			default:
				return FO_FAILED;
		}
	}
    
	HANDLE	hSrcFile = ::CreateFile( szSourceFileName, GENERIC_READ, FILE_SHARE_READ, NULL, 
									 OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL );
	if (hSrcFile == INVALID_HANDLE_VALUE) {
		return FO_SOURCE_UNAVAILABLE;
	}

	HANDLE	hDestFile = ::CreateFile( szDestFileName, GENERIC_WRITE, 0, NULL, 
									  CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL );
	if (hDestFile == INVALID_HANDLE_VALUE) {
		::CloseHandle( hSrcFile );
		return FO_DEST_UNAVAILABLE;
	}

	DWORD	bufferSize = CAdrenalin::getInstance().getFileBufferSize();
	BYTE*	buffer     = CAdrenalin::getInstance().getFileBuffer();

	DWORD	dwBytesRead, dwBytesWritten;

	dwBytesRead = 1;	// dummy for future check
	FileOpResult	foResult = FO_SUCCEEDED;
	do {
		if (!ReadFile( hSrcFile, buffer, bufferSize, &dwBytesRead, NULL )) {
			foResult = FO_READ_FAILED;
			break;
		}
		if (dwBytesRead == 0) {
			break;
		}
		DWORD	offset = 0;
		do {
			if (!WriteFile( hDestFile, buffer + offset, dwBytesRead - offset, &dwBytesWritten, NULL )
				|| dwBytesWritten == 0)
			{
				foResult = FO_WRITE_FAILED;
				break;
			}
			offset += dwBytesWritten;
		} while (offset < dwBytesRead);
	} while (foResult == FO_SUCCEEDED);
	if (foResult == FO_SUCCEEDED) {
		FILETIME	ftCreation;
		::GetFileTime( hSrcFile,  &ftCreation, NULL, NULL );
		::SetFileTime( hDestFile, &ftCreation, NULL, NULL );
		::CloseHandle( hSrcFile );
		::CloseHandle( hDestFile );
		::DeleteFile( szSourceFileName );
		return FO_SUCCEEDED;
	}
	::CloseHandle( hSrcFile );
	::CloseHandle( hDestFile );
	::DeleteFile( szDestFileName );
	return foResult;
}


FileOpResult MyCopyFile(LPCTSTR szSourceFileName, LPCTSTR szDestFileName) {
	HANDLE	hSrcFile = ::CreateFile( szSourceFileName, GENERIC_READ, FILE_SHARE_READ, NULL, 
									 OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL );
	if (hSrcFile == INVALID_HANDLE_VALUE) {
		return FO_SOURCE_UNAVAILABLE;
	}

	HANDLE	hDestFile = ::CreateFile( szDestFileName, GENERIC_WRITE, 0, NULL, 
									  CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL );
	if (hDestFile == INVALID_HANDLE_VALUE) {
		::CloseHandle( hSrcFile );
		return FO_DEST_UNAVAILABLE;
	}

	DWORD	bufferSize = CAdrenalin::getInstance().getFileBufferSize();
	BYTE*	buffer     = CAdrenalin::getInstance().getFileBuffer();

	DWORD	dwBytesRead, dwBytesWritten;

	FileOpResult	foResult = FO_SUCCEEDED;
	do {
		if (!::ReadFile( hSrcFile, buffer, bufferSize, &dwBytesRead, NULL )) {
			foResult = FO_READ_FAILED;
			break;
		}
		if (dwBytesRead == 0) {
			break;
		}
		DWORD	offset = 0;
		do {
			if (!::WriteFile( hDestFile, buffer + offset, dwBytesRead - offset, &dwBytesWritten, NULL ) ||
				dwBytesWritten == 0)
			{
				foResult = FO_WRITE_FAILED;
				break;
			}
			offset += dwBytesWritten;
		} while (offset < dwBytesRead);
	} while (foResult == FO_SUCCEEDED);

	if (foResult == FO_SUCCEEDED) {
		FILETIME	ftCreation;
		::GetFileTime( hSrcFile,  &ftCreation, NULL, NULL );
		::SetFileTime( hDestFile, &ftCreation, NULL, NULL );
		::CloseHandle( hSrcFile );
		::CloseHandle( hDestFile );
		return FO_SUCCEEDED;
	}

	::CloseHandle( hSrcFile );
	::CloseHandle( hDestFile );
	::DeleteFile( szDestFileName );

	return foResult;
}

void ConvertNameToShort(LPCTSTR szSrc, LPTSTR szDest) {
#if defined(_UNICODE)
	if (!GetShortPathName( szSrc, szDest, MAX_PATH ))
		lstrcpy( szDest, szSrc );
#else
	TCHAR	szShortName[MAX_PATH];
	TCHAR	szAnsiName[MAX_PATH];
	BOOL	fApisWereANSI;

	fApisWereANSI = AreFileApisANSI();
	if (!fApisWereANSI)
		SetFileApisToANSI();
	OemToChar( szSrc, szAnsiName );
	if (GetShortPathName( szAnsiName, szShortName, sizeof(szShortName) ))
		CharToOem( szShortName, szDest );
	else
		lstrcpy( szDest, szSrc );
	if (!fApisWereANSI)
		SetFileApisToOEM();
#endif
}

void ConvertANSINameToShort(LPCTSTR szSrc, LPTSTR szDest) {
#if defined(_UNICODE)
	if (!GetShortPathName( szSrc, szDest, MAX_PATH ))
		lstrcpy( szDest, szSrc );
#else
	TCHAR	szShortName[MAX_PATH];
	BOOL	fApisWereANSI;

	fApisWereANSI = AreFileApisANSI();
	if (!fApisWereANSI)
		SetFileApisToANSI();
	if (GetShortPathName( szSrc, szShortName, sizeof(szShortName) ))
		lstrcpy( szDest, szShortName );
	else
		lstrcpy( szDest, szSrc );
	if (!fApisWereANSI)
		SetFileApisToOEM();
#endif
}

void StrNCpy(char *Dest, const char *Source, int Number) {
    while (Number > 0 && *Source != '\0') {
        *Dest = *Source;
        Source++;
        Dest++;
        Number--;
    }
    *Dest = '\0';
}

void ConvertSoftCR(LPTSTR szData) {
	while (*szData != _T('\0')) {
		if (*szData == _T(''))		// russian
			*szData = _T('H');	// english
		szData++;
	}
}

void FormatSize(int size, char *buf) {
    int i, j, len, count;

    sprintf( buf, "%ld", size );
    len = strlen(buf);

    count = 0; 
    for (i = len-1; i >= 0; i--) {
        count++;
        if ((count == 3) && (i > 0)) { // insert ','
            count = 0;
            // shift reminder left
            for (j = len+1; j > i; j--)
                buf[j] = buf[j-1];
            len++;
            buf[i] = ',';
        }
    }
}

int CreateFileFlag(const char *FlagName) {
    FILE *f;

    f = fopen( FlagName, "rb" );
    if (f != NULL) {
        // file already exist
        fclose(f);
        return (1);
    }
    f = fopen( FlagName, "wb" );
    if (f == NULL) {
        // failed
        return (0);
    }
    // success
    fclose(f);
    return (1);
}

BOOL parseIntWithCommas(char* str, DWORD& d) {
	d = 0;

	while (*str != '\0') {
		if (*str == ',') {
			str++;
			continue;
		}
		if (!isdigit(*str))
			return FALSE;
		d *= 10;
		d += *str - '0';
		str++;
	}
	return TRUE;
}


bool ParseYesNo(LPCTSTR szValue, bool& bResult) {
	if (lstrcmpi( szValue, TEXT("YES") ) == 0) {
		bResult = true;
		return (true);
	}
	if (lstrcmpi( szValue, TEXT("NO") ) == 0) {
		bResult = false;
		return (true);
	}

	// failed
	return (false);
}

bool ParseYesNo(LPCTSTR szValue, CFlag& flagResult) {
	if (lstrcmpi( szValue, TEXT("YES") ) == 0) {
		flagResult = true;
		return (true);
	}
	if (lstrcmpi( szValue, TEXT("NO") ) == 0) {
		flagResult = false;
		return (true);
	}

	// failed
	return (false);
}

void	removeBoundarySpaces(char* source, char* dest) {
	while (*source == ' ')
		source++;

	int	len = strlen(source);
	int	i   = len-1;
	while (len > 0 && source[i] == ' ') {
		len--;
		i--;
	}

	if (len > 0)
		memcpy( dest, source, len );
	dest[len] = '\0';
}

int	arrMonthDays[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

int GetDays(WORD wDay, WORD wMonth, WORD wYear) {
	int	nDays = wYear*365;
	// consider previous leap-years
	nDays += (wYear+3) / 4;
	for (int i = 0; i < wMonth-1; i++) {
		nDays += arrMonthDays[i];
	}
	// check leap-year
	if ((wYear % 4) == 0 && wMonth > 2)
		nDays++;
	nDays += wDay;
	return (nDays);
}

LPTSTR	ConcatStrings( LPTSTR szDest, LPCTSTR szHead, LPCTSTR szTail) {
	lstrcpy( szDest, szHead );
	lstrcat( szDest, szTail );
	return (szDest);
}

DWORD WriteCharString(HANDLE hFile, LPCTSTR szData) {
	static char	szOemBuf[STR_BUF_SIZE];
	DWORD		dwNumberOfBytesWritten;
	CharToOem( szData, szOemBuf );
	WriteFile( (HANDLE)hFile, szOemBuf, strlen( szOemBuf ), &dwNumberOfBytesWritten, 
		NULL );
	return (dwNumberOfBytesWritten);
}


TCHAR ToUpper(TCHAR c) {
#if defined(UNICODE)
	return (towupper(c);
#else
	return (toupper(c));
#endif
}


TCHAR ToLower(TCHAR c) {
#if defined(UNICODE)
	return (towlower(c);
#else
	return (tolower(c));
#endif
}


bool StrToInt(LPCTSTR szValue, int& iValue) {
	int	iCurValue;
	int	iPrevValue;
	bool	fNegative;

	if (*szValue == _T('-')) {
		fNegative = true;
		szValue++;
	}
	else {
		fNegative = false;
	}

	iCurValue = 0;
	while (_istdigit(*szValue)) {
		iPrevValue = iCurValue;
		iCurValue *= 10;
		iCurValue += (*szValue) - _T('0');
		if (iPrevValue > iCurValue) {
			// overflow
			iValue = 0;
			return (false);
		}
		szValue++;
	}
	if (*szValue != _T('\0')) {
		// syntax error
		iValue = 0;
		return (false);
	}
	iValue = fNegative ? (-iCurValue) : iCurValue;
	return (true);
}

bool HaveSlashes(LPCTSTR szValue) {
	while (*szValue != _T('\0')) {
		if (*szValue == _T('\\'))
			return (true);
		szValue++;
	}
	return (false);
}

bool HasSpaces(LPCTSTR szValue) {
	while (*szValue != _T('\0')) {
		if (*szValue == _T(' '))
			return (true);
		szValue++;
	}
	return (false);
}


//template <class T>
void AppendVector(VTString& body, VTString& tail) {
	VTString::iterator	it = tail.begin();
	while (it != tail.end()) {
		body.push_back( *it );
		it++;
	}
}
